package ru.yandex.solomon.metrics.client;

import java.util.Collections;
import java.util.Set;

import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Vladimir Gordiychuk
 */
public class UniqueLabelsResponse implements MetabaseStatusAware, CrossDcStatusAware {
    private final MetabaseStatus status;
    private final Set<Labels> uniqueLabels;
    private final boolean allDestSuccess;

    public UniqueLabelsResponse(MetabaseStatus status) {
        this(status, Collections.emptySet(), false);
    }

    public UniqueLabelsResponse(Set<Labels> uniqueLabels) {
        this(MetabaseStatus.OK, uniqueLabels, true);
    }

    public UniqueLabelsResponse(MetabaseStatus status, Set<Labels> uniqueLabels, boolean allDestSuccess) {
        this.status = status;
        this.uniqueLabels = uniqueLabels;
        this.allDestSuccess = allDestSuccess;
    }

    @Override
    public MetabaseStatus getStatus() {
        return status;
    }

    public Set<Labels> getUniqueLabels() {
        return uniqueLabels;
    }

    @Override
    public boolean isAllDestSuccess() {
        return allDestSuccess;
    }
}
