package ru.yandex.solomon.metrics.client.cache;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.labels.query.Selectors;
import ru.yandex.solomon.metrics.client.FindRequest;
import ru.yandex.solomon.metrics.client.FindResponse;
import ru.yandex.solomon.metrics.client.MetricsClient;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class MetabaseFindCacheStub implements MetabaseFindCache {
    private final MetricsClient metricsClient;

    public MetabaseFindCacheStub(MetricsClient metricsClient) {
        this.metricsClient = metricsClient;
    }

    @Override
    public CompletableFuture<FindResponse> find(Selectors selectors, int limit, long softDeadline, long deadlineMillis) {
        return metricsClient.find(FindRequest.newBuilder()
                .setSoftDeadline(softDeadline)
                .setDeadline(deadlineMillis)
                .setLimit(limit)
                .setSelectors(selectors)
                .build());
    }

}
