package ru.yandex.solomon.metrics.client.cache;

import java.util.concurrent.ThreadLocalRandom;

/**
 * @author Vladimir Gordiychuk
 */
public class TimeExpiredItem<T> {
    private final T payload;
    private final long expiredAt;

    public TimeExpiredItem(T payload, long ttl, long now) {
        this.payload = payload;
        if (ttl == 0) {
            this.expiredAt = now;
        } else {
            long halfTtl = ttl / 2;
            this.expiredAt = now + halfTtl + ThreadLocalRandom.current().nextLong(halfTtl);
        }
    }

    public T getPayload() {
        return payload;
    }

    public boolean isExpired(long now) {
        return now > expiredAt;
    }
}
