package ru.yandex.solomon.metrics.client.cache;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.config.OptionalSet;
import ru.yandex.solomon.config.protobuf.metabase.client.TMetabaseClientConfig;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class UnrollClientOptions {
    private final Duration expireTtl;

    public UnrollClientOptions(Duration expireTtl) {
        this.expireTtl = expireTtl;
    }

    public Duration getExpireTtl() {
        return expireTtl;
    }

    public static UnrollClientOptions create(TMetabaseClientConfig.UniqueLabelsCacheOptions proto) {
        Builder builder = newBuilder();

        OptionalSet.setTime(builder::setExpireTtl, proto.getExpireTtl());

        return builder.build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Duration expireTtl = Duration.ofMinutes(4);

        public Builder setExpireTtl(long value, TimeUnit unit) {
            this.expireTtl = Duration.ofMillis(unit.toMillis(value));
            return this;
        }

        public UnrollClientOptions build() {
            return new UnrollClientOptions(expireTtl);
        }
    }
}
