package ru.yandex.solomon.metrics.client.cache;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.metrics.client.MetricsClient;
import ru.yandex.solomon.metrics.client.UniqueLabelsRequest;
import ru.yandex.solomon.metrics.client.UniqueLabelsResponse;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class UnrollClientStub implements UnrollClient {
    private final MetricsClient metricsClient;

    public UnrollClientStub(MetricsClient metricsClient) {
        this.metricsClient = metricsClient;
    }

    @Override
    public CompletableFuture<UniqueLabelsResponse> uniqueLabels(UniqueLabelsRequest request) {
        return metricsClient.uniqueLabels(request);
    }
}
