package ru.yandex.solomon.metrics.client.combined;

import java.time.Duration;
import java.time.temporal.ChronoUnit;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.metrics.client.TimeSeriesSizeCounter;
import ru.yandex.solomon.metrics.client.exceptions.MemoryLimitForGraphIsReached;
import ru.yandex.solomon.util.time.Interval;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class DataLimits {

    public static final int MAX_LABEL_VALUES_COUNT = 100_000;
    public static final int MAX_METRIC_NAMES_COUNT = 100_000;

    public static final int MAX_METRICS_COUNT = 640;
    public static final int MAX_METRICS_FOR_AGGR_COUNT = 10_000;
    public static final int MAX_METRICS_FOR_TOP_COUNT = 20_000;

    public static final int MAX_POINTS_COUNT = 10_000;
    public static final int MIN_POINTS_COUNT = 10;

    public static final int MIN_INTERVAL_SECONDS = 1;
    public static final int MAX_INTERVAL_YEARS = 10;
    public static final int MAX_INTERVAL_DAYS_FOR_RAW_DATA = 7;

    public static final int MAX_METRIC_LINES_IN_BYTES = 100 * 1024 * 1024; // 100 MiB ~ 6.6 Mpoints = 660 ts x 10k points/ts
    public static final int HUGE_RESPONSE_THRESHOLD = 1 << 20; // 1 MiB

    public static final long MIN_INTERVAL_MILLIS =
        Duration.ofSeconds(DataLimits.MIN_INTERVAL_SECONDS).toMillis();
    public static final long MAX_INTERVAL_MILLIS =
        DataLimits.MAX_INTERVAL_YEARS * ChronoUnit.YEARS.getDuration().toMillis();
    public static final long MAX_INTERVAL_MILLIS_FOR_RAW_DATA =
        MAX_INTERVAL_DAYS_FOR_RAW_DATA * ChronoUnit.DAYS.getDuration().toMillis();

    public static void ensureResponseSizeLimit(Interval interval, long gridMillis, int metrics) {
        long responseSizeBytes = TimeSeriesSizeCounter.estimatedLoadSizeInBytes(metrics, interval, gridMillis);
        if (responseSizeBytes >= DataLimits.MAX_METRIC_LINES_IN_BYTES) {
            throw new MemoryLimitForGraphIsReached(metrics, interval.duration().toMillis(), gridMillis,
                    responseSizeBytes, DataLimits.MAX_METRIC_LINES_IN_BYTES);
        }
    }
}
