package ru.yandex.solomon.metrics.client.combined;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.math.operation.Metric;
import ru.yandex.solomon.metrics.client.MetabaseStatus;
import ru.yandex.solomon.metrics.client.StockpileStatus;
import ru.yandex.solomon.model.MetricKey;
import ru.yandex.solomon.util.client.StatusAware;
import ru.yandex.stockpile.api.EStockpileStatusCode;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class FindAndReadManyResponse implements StatusAware {
    private final MetabaseStatus metaStatus;
    private final StockpileStatus storageStatus;
    private final List<Metric<MetricKey>> metrics;

    private final OldModeResult modeResult;

    private FindAndReadManyResponse(
            MetabaseStatus metaStatus,
            StockpileStatus storageStatus,
            List<Metric<MetricKey>> metrics,
            OldModeResult modeResult)
    {
        this.metaStatus = metaStatus;
        this.storageStatus = storageStatus;
        this.metrics = metrics;

        this.modeResult = modeResult;
    }

    public FindAndReadManyResponse(List<Metric<MetricKey>> metrics, OldModeResult modeResult) {
        this(MetabaseStatus.OK, StockpileStatus.OK, metrics, modeResult);
    }

    public FindAndReadManyResponse(MetabaseStatus status) {
        this(status, StockpileStatus.OK, List.of(), OldModeResult.DEFAULT);
    }

    public FindAndReadManyResponse(StockpileStatus status) {
        this(MetabaseStatus.OK, status, List.of(), OldModeResult.DEFAULT);
    }

    public List<Metric<MetricKey>> getMetrics() {
        return metrics;
    }

    @Deprecated(since = "don't rely on this if not in __oldMode")
    public OldModeResult getModeResult() {
        return modeResult;
    }

    public MetabaseStatus getMetaStatus() {
        return metaStatus;
    }

    public StockpileStatus getStorageStatus() {
        return storageStatus;
    }

    @Override
    public boolean isOk() {
        return metaStatus.isOk() && storageStatus.getCode() == EStockpileStatusCode.OK;
    }
}
