package ru.yandex.solomon.metrics.client.combined;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class OldModeResult {
    public static final OldModeResult DEFAULT = new OldModeResult(false, false);

    private final boolean truncated;
    private final boolean summary;

    public OldModeResult(boolean truncated, boolean summary) {
        this.truncated = truncated;
        this.summary = summary;
    }

    public boolean isTruncated() {
        return truncated;
    }

    public boolean isSummary() {
        return summary;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OldModeResult that = (OldModeResult) o;
        return truncated == that.truncated &&
            summary == that.summary;
    }

    @Override
    public int hashCode() {
        return Objects.hash(truncated, summary);
    }

    @Override
    public String toString() {
        return "OldModeResult{" +
            "truncated=" + truncated +
            ", summary=" + summary +
            '}';
    }
}
