package ru.yandex.solomon.metrics.client.dataproxy;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monitoring.dataproxy.ReadManyResponse;
import ru.yandex.solomon.math.protobuf.Aggregate;
import ru.yandex.solomon.model.timeseries.aggregation.AggregateConverters;
import ru.yandex.solomon.model.timeseries.aggregation.TimeseriesSummary;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AggregateDecoder {
    @Nullable
    public static TimeseriesSummary fromProto(ReadManyResponse.MetricData proto) {
        if (!proto.hasAggregate()) {
            return null;
        }
        Aggregate aggr = proto.getAggregate();
        switch (aggr.getTypeCase()) {
            case DOUBLE:
                return AggregateConverters.fromProto(aggr.getDouble());
            case INT64:
                return AggregateConverters.fromProto(aggr.getInt64());
            case HISTOGRAM:
                return AggregateConverters.fromProto(aggr.getHistogram());
            case LOG_HISTOGRAM:
                return AggregateConverters.fromProto(aggr.getLogHistogram());
            case SUMMARY_DOUBLE:
                return AggregateConverters.fromProto(aggr.getSummaryDouble());
            case SUMMARY_INT64:
                return AggregateConverters.fromProto(aggr.getSummaryInt64());
            default:
                throw new UnsupportedOperationException("Unsupported aggregate: " + aggr.getTypeCase());
        }
    }
}
