package ru.yandex.solomon.metrics.client.dataproxy;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monitoring.dataproxy.ReadManyResponse;
import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.solomon.metrics.client.TimeSeriesCodec;
import ru.yandex.solomon.model.timeseries.AggrGraphDataIterable;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
class TimeseriesDecoder {
    private TimeseriesDecoder() {}

    public static int getCurrentTimeseriesFormat() {
        return StockpileFormat.CURRENT.getFormat();
    }

    @Nullable
    public static AggrGraphDataIterable fromProto(ReadManyResponse.MetricData metricData) {
        return metricData.hasTimeSeries()
                ? TimeSeriesCodec.sequenceDecode(metricData.getTimeSeries())
                : null;
    }
}
