package ru.yandex.solomon.metrics.client.dc;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.metrics.client.AbstractRequest;

/**
 * @author Vladimir Gordiychuk
 */
public abstract class ClientCall<ReqT extends AbstractRequest, RespT> {
    private final ReqT request;

    public ClientCall(ReqT request) {
        this.request = request;
    }

    public ReqT getRequest() {
        return request;
    }

    public abstract CompletableFuture<RespT> call();
}
