package ru.yandex.solomon.metrics.client.dc;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.metrics.client.AbstractRequest;

/**
 * @author Vladimir Gordiychuk
 */
public class ClientCallConstant<ReqT extends AbstractRequest, RespT> extends ClientCall<ReqT, RespT> {
    private final RespT response;

    public ClientCallConstant(ReqT request, RespT response) {
        super(request);
        this.response = response;
    }

    @Override
    public CompletableFuture<RespT> call() {
        return CompletableFuture.completedFuture(response);
    }
}
