package ru.yandex.solomon.metrics.client.exceptions;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.solomon.util.time.DurationUtils;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class MemoryLimitForGraphIsReached extends DataClientException {

    @JsonProperty("metric_count")
    public final int metricCount;

    @JsonProperty("interval_millis")
    public final long intervalMillis;

    @JsonProperty("grid_millis")
    public final long gridMillis;

    @JsonProperty("response_size_bytes")
    public final long responseSizeBytes;

    @JsonProperty("limit_bytes")
    public final long limitBytes;

    public MemoryLimitForGraphIsReached(int metricCount, long intervalMillis, long gridMillis, long responseSizeBytes, long limitBytes) {
        super("Memory limit for graph data response is reached, please decrease lines count or interval duration: "
                    + "metrics requests count - " + metricCount
                    + ", interval duration - " + DurationUtils.formatDurationMillis(intervalMillis)
                    + ", downsampling grid - " + DurationUtils.formatDurationMillis(gridMillis)
                    + ", response size - " + DataSize.shortString(responseSizeBytes)
                    + " >= " + DataSize.shortString(limitBytes));
        this.metricCount = metricCount;
        this.intervalMillis = intervalMillis;
        this.gridMillis = gridMillis;
        this.responseSizeBytes = responseSizeBytes;
        this.limitBytes = limitBytes;
    }
}
