package ru.yandex.solomon.metrics.client.exceptions;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class TooManyMetricsLoaded extends DataClientException {

    @JsonProperty("max_loaded_metric_count")
    public final int maxLoadedMetricCount;

    public TooManyMetricsLoaded(int maxLoadedMetricCount) {
        super("Too many metrics are loaded, expected not more than: " + maxLoadedMetricCount);
        this.maxLoadedMetricCount = maxLoadedMetricCount;
    }
}
