package ru.yandex.solomon.metrics.client.exceptions;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.labels.query.Selectors;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class TooManyMetricsLoadedBySelectors extends DataClientException {

    @JsonProperty
    public final String selectors;

    @JsonProperty("metabase_limit")
    public final int metabaseLimit;

    public TooManyMetricsLoadedBySelectors(Selectors selectors, int metabaseLimit) {
        super("Too many metrics are loaded by selectors " + selectors + ", " + "expected not more than: " + metabaseLimit);
        this.selectors = Selectors.format(selectors);
        this.metabaseLimit = metabaseLimit;
    }
}
