package ru.yandex.solomon.metrics.client.exceptions;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class TooManyMetricsReturnedPerGraph extends DataClientException {

    @JsonProperty
    public final int returned;

    @JsonProperty("per_graph_limit")
    public final int perGraphLimit;

    public TooManyMetricsReturnedPerGraph(int returned, int perGraphLimit) {
        super("Returned " + returned + " metrics, it exceeds the limit: " + perGraphLimit + " metrics per one graph");
        this.returned = returned;
        this.perGraphLimit = perGraphLimit;
    }
}
