package ru.yandex.solomon.metrics.client;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.Range;

import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.solomon.selfmon.AvailabilityStatus;
import ru.yandex.stockpile.api.CreateMetricRequest;
import ru.yandex.stockpile.api.CreateMetricResponse;
import ru.yandex.stockpile.api.DeleteMetricDataRequest;
import ru.yandex.stockpile.api.DeleteMetricDataResponse;
import ru.yandex.stockpile.api.DeleteMetricRequest;
import ru.yandex.stockpile.api.DeleteMetricResponse;
import ru.yandex.stockpile.api.ReadMetricsMetaRequest;
import ru.yandex.stockpile.api.ReadMetricsMetaResponse;
import ru.yandex.stockpile.api.TAllocateLocalIdsRequest;
import ru.yandex.stockpile.api.TAllocateLocalIdsResponse;
import ru.yandex.stockpile.api.TCompressedReadManyResponse;
import ru.yandex.stockpile.api.TCompressedReadResponse;
import ru.yandex.stockpile.api.TCompressedWriteRequest;
import ru.yandex.stockpile.api.TCompressedWriteResponse;
import ru.yandex.stockpile.api.TDeleteMetricByShardRequest;
import ru.yandex.stockpile.api.TDeleteMetricByShardResponse;
import ru.yandex.stockpile.api.TReadManyRequest;
import ru.yandex.stockpile.api.TReadRequest;
import ru.yandex.stockpile.api.TReadResponse;
import ru.yandex.stockpile.api.TShardCommandRequest;
import ru.yandex.stockpile.api.TShardCommandResponse;
import ru.yandex.stockpile.api.TUncompressedReadManyResponse;
import ru.yandex.stockpile.api.TWriteDataBinaryRequest;
import ru.yandex.stockpile.api.TWriteDataBinaryResponse;
import ru.yandex.stockpile.api.TWriteLogRequest;
import ru.yandex.stockpile.api.TWriteLogResponse;
import ru.yandex.stockpile.api.TWriteRequest;
import ru.yandex.stockpile.api.TWriteResponse;
import ru.yandex.stockpile.client.StockpileClient;
import ru.yandex.stockpile.client.mem.AccumulatedShardCommand;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public abstract class AbstractStockpileClientStub implements StockpileClient {
    public volatile Supplier<CompletableFuture<?>> beforeSupplier;

    @Override
    public CompletableFuture<CreateMetricResponse> createMetric(CreateMetricRequest request) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public CompletableFuture<DeleteMetricResponse> deleteMetric(DeleteMetricRequest request) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public CompletableFuture<DeleteMetricDataResponse> deleteMetricData(DeleteMetricDataRequest request) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public CompletableFuture<TWriteResponse> writeOne(TWriteRequest request) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public CompletableFuture<TCompressedWriteResponse> writeCompressedOne(TCompressedWriteRequest request) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public CompletableFuture<TWriteDataBinaryResponse> writeDataBinary(TWriteDataBinaryRequest request) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public CompletableFuture<TWriteLogResponse> writeLog(TWriteLogRequest request) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public CompletableFuture<TShardCommandResponse> bulkShardCommand(TShardCommandRequest request) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public CompletableFuture<TShardCommandResponse> bulkShardCommand(AccumulatedShardCommand commands) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public CompletableFuture<TReadResponse> readOne(TReadRequest readRequest) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public CompletableFuture<TUncompressedReadManyResponse> readUncompressedMany(TReadManyRequest request) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public CompletableFuture<TCompressedReadResponse> readCompressedOne(TReadRequest request) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public CompletableFuture<TCompressedReadManyResponse> readCompressedMany(TReadManyRequest request) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public CompletableFuture<ReadMetricsMetaResponse> readMetricsMeta(ReadMetricsMetaRequest request) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public Range<Integer> getCompatibleCompressFormat() {
        return Range.closed(StockpileFormat.CURRENT.getFormat(), StockpileFormat.CURRENT.getFormat());
    }

    @Override
    public CompletableFuture<Void> forceUpdateClusterMetaData() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<TAllocateLocalIdsResponse> allocateLocalIds(TAllocateLocalIdsRequest request) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public CompletableFuture<TDeleteMetricByShardResponse> deleteMetricByShard(TDeleteMetricByShardRequest request) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public int getReadyShardsCount() {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public int getTotalShardsCount() {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public AvailabilityStatus getAvailability() {
        return AvailabilityStatus.AVAILABLE;
    }

    @Override
    public String getHostForShardId(int shardId) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public void close() {
    }

    protected CompletableFuture<?> before() {
        var copy = beforeSupplier;
        if (copy == null) {
            return CompletableFuture.completedFuture(null);
        }

        return copy.get();
    }
}
