package ru.yandex.solomon.metrics.client;

import com.google.protobuf.ByteString;

import ru.yandex.solomon.codec.archive.MetricArchiveMutable;
import ru.yandex.solomon.codec.archive.serializer.MetricArchiveNakedSerializer;
import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.solomon.model.protobuf.TimeSeries;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayList;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;
import ru.yandex.stockpile.api.TCompressedReadResponse;

/**
 * @author Vladimir Gordiychuk
 */
public final class TimeSeriesCodecTestSupport {
    private TimeSeriesCodecTestSupport() {
    }

    public static TimeSeries.Chunk encodeChunk(AggrGraphDataArrayList chunk) {
        return encodeChunk(StockpileFormat.CURRENT, chunk);
    }

    public static TimeSeries.Chunk encodeChunk(StockpileFormat format, AggrGraphDataArrayList chunk) {
        ByteString compressed = MetricArchiveNakedSerializer.serializerForFormatSealed(format)
                .serializeToByteString(MetricArchiveMutable.of(chunk).toImmutable());

        TimeSeries.Chunk.Builder builder = TimeSeries.Chunk.newBuilder()
                .setContent(compressed)
                .setPointCount(chunk.length());

        if (!chunk.isEmpty()) {
            builder.setFromMillis(chunk.getTsMillis(0));
            builder.setToMillis(chunk.getTsMillis(chunk.length() - 1));
        }

        return builder.build();
    }

    public static AggrGraphDataArrayList decode(TCompressedReadResponse response) {
        AggrGraphDataListIterator iterator = TimeSeriesCodec.sequenceDecode(response).iterator();
        AggrGraphDataArrayList result = new AggrGraphDataArrayList(iterator.columnSetMask(), 10);
        result.addAllFrom(iterator);
        return result;
    }
}
