package ru.yandex.solomon.metrics.client;

import java.util.Set;

import org.junit.Test;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.model.MetricKey;
import ru.yandex.solomon.model.StockpileKey;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class ReadManyRequestTest {

    @Test(expected = IllegalArgumentException.class)
    public void keyRequired() {
        ReadManyRequest.newBuilder()
                .setFromMillis(System.currentTimeMillis())
                .setToMillis(System.currentTimeMillis() + 180_000)
                .build();
    }

    @Test
    public void readManyOneDc() {
        var request = ReadManyRequest.newBuilder()
                .addKey(new MetricKey(MetricType.DGAUGE, Labels.of("name", "alice"),
                        new StockpileKey("vla", 1, 2)))
                .build();

        assertEquals(Set.of("vla"), request.getDestinations());
    }

    @Test
    public void readManyManyDc() {
        var request = ReadManyRequest.newBuilder()
                .addKey(new MetricKey(MetricType.DGAUGE, Labels.of("name", "alice"),
                        new StockpileKey("vla", 1, 2)))
                .addKey(new MetricKey(MetricType.DGAUGE, Labels.of("name", "bob"),
                        new StockpileKey("sas", 3, 4)))
                .build();

        assertEquals(Set.of("sas", "vla"), request.getDestinations());
    }

    @Test
    public void overrideDestination() {
        var request = ReadManyRequest.newBuilder()
                .setDestination("sas")
                .addKey(new MetricKey(MetricType.DGAUGE, Labels.of("name", "alice"),
                        new StockpileKey("vla", 1, 2)))
                .addKey(new MetricKey(MetricType.DGAUGE, Labels.of("name", "bob"),
                        new StockpileKey("sas", 3, 4)))
                .build();

        assertEquals(Set.of("sas"), request.getDestinations());
    }
}
