package ru.yandex.solomon.metrics.client;

import java.util.List;
import java.util.Set;

import org.junit.Test;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.model.MetricKey;
import ru.yandex.solomon.model.StockpileKey;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class ReadRequestTest {

    @Test
    public void oneDcRequest() {
        var request = ReadRequest.newBuilder()
                .setKey(new MetricKey(MetricType.DGAUGE, Labels.of("name", "alice"),
                        new StockpileKey("vla", 1, 2)))
                .build();

        assertEquals(Set.of("vla"), request.getDestinations());
    }

    @Test
    public void multipleDc() {
        var request = ReadRequest.newBuilder()
                .setKey(new MetricKey(MetricType.DGAUGE, null, Labels.of("name", "alice"), 0,
                        List.of(new StockpileKey("vla", 1, 2),
                                new StockpileKey("sas", 3, 4))))
                .build();
        assertEquals(Set.of("vla", "sas"), request.getDestinations());
    }

    @Test
    public void overrideDestination() {
        var request = ReadRequest.newBuilder()
                .setDestination("sas")
                .setKey(new MetricKey(MetricType.DGAUGE, null, Labels.of("name", "alice"), 0,
                        List.of(new StockpileKey("vla", 1, 2),
                                new StockpileKey("sas", 3, 4))))
                .build();
        assertEquals(Set.of("sas"), request.getDestinations());
    }
}
