package ru.yandex.solomon.metrics.parser;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.TimeUnit;

import com.google.common.io.Resources;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

import ru.yandex.misc.ExceptionUtils;
import ru.yandex.solomon.metrics.parser.json.JacksonJsonParser;

/**
 * @author Stepan Koltsov
 */
@State(Scope.Thread)
@OutputTimeUnit(TimeUnit.MICROSECONDS)
@Warmup(iterations = 3)
@Measurement(iterations = 6)
@BenchmarkMode(Mode.AverageTime)
@Fork(2)
public class JsonParserBenchmark {

    @State(Scope.Thread)
    public static class MyState {
        private ByteBuf bytes = loadBytes1();
    }

    private static ByteBuf loadBytes1() {
        try {
            URL resource = JsonParserBenchmark.class.getResource("sensors_test_data.json");
            return Unpooled.wrappedBuffer(Resources.toByteArray(resource));
        } catch (IOException e) {
            throw ExceptionUtils.throwException(e);
        }
    }

    @Benchmark
    public void streamJackson(MyState state) {
        JacksonJsonParser.I.forEachMetric(state.bytes.slice(), s -> {});
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder()
            .include(JsonParserBenchmark.class.getSimpleName())
            .build();
        new Runner(opt).run();
    }
}
