package ru.yandex.solomon.metrics.parser;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.util.collection.enums.EnumMapToLong;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class ErrorListenerCounter implements TreeParser.ErrorListener {

    public EnumMapToLong<TreeParser.InvalidMetricReason> invalidMetrics =
        new EnumMapToLong<>(TreeParser.InvalidMetricReason.class);

    @Override
    public void invalidMetric(TreeParser.InvalidMetricReason invalidMetricReason) {
        invalidMetrics.incrementAndGet(invalidMetricReason);
    }

    public boolean anyErrors() {
        return invalidMetrics.sumValues() != 0;
    }

    @Override
    public String toString() {
        return "{invalidSensors=" + invalidMetrics + '}';
    }
}
