package ru.yandex.solomon.metrics.parser;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.primitives.Rate;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class FormatListenerCounter implements TreeParser.FormatListener {

    private final Rate oldFormatMetrics;
    private final Rate newFormatMetrics;

    public FormatListenerCounter(Rate oldFormatMetrics, Rate newFormatMetrics) {
        this.oldFormatMetrics = oldFormatMetrics;
        this.newFormatMetrics = newFormatMetrics;
    }

    public void register(boolean useNewFormat) {
        if (useNewFormat) {
            newFormatMetrics.inc();
        } else {
            oldFormatMetrics.inc();
        }
    }
}
