package ru.yandex.solomon.metrics.parser;

import java.util.Map;
import java.util.stream.Collectors;

import it.unimi.dsi.fastutil.doubles.Double2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.histogram.Doubles;
import ru.yandex.monlib.metrics.histogram.HistogramSnapshot;
import ru.yandex.monlib.metrics.histogram.Histograms;
import ru.yandex.monlib.metrics.labels.Label;
import ru.yandex.monlib.metrics.labels.LabelAllocator;
import ru.yandex.monlib.metrics.series.TimeSeries;
import ru.yandex.solomon.labels.LabelKeys;

/**
 * @author Vladimir Gordiychuk
 */
// TODO: it's temporary solution to store each histogram bucket as separate metric (gordiychuk@),
// after support histogram on stockpile side should be dropped
public class HistogramUtils {

    public static Object2LongMap<Label> splitBuckets(HistogramSnapshot snapshot, LabelAllocator labelAllocator) {
        Object2LongOpenHashMap<Label> result = new Object2LongOpenHashMap<>(snapshot.count());
        for (int index = 0; index < snapshot.count(); index++) {
            Label label = boundToLabel(snapshot.upperBound(index), labelAllocator);
            result.put(label, snapshot.value(index));
        }
        return result;
    }

    public static Map<Label, TimeSeries> splitBuckets(TimeSeries timeSeries, LabelAllocator labelAllocator) {
        Double2ObjectOpenHashMap<TimeSeries> bucketTimeSeries = new Double2ObjectOpenHashMap<>();

        for (int index = 0; index < timeSeries.size(); index++) {
            final long ts = timeSeries.tsMillisAt(index);
            final HistogramSnapshot snapshot = timeSeries.histogramAt(index);
            for (int bucketIndex = 0; bucketIndex < snapshot.count(); bucketIndex++) {
                double bound = snapshot.upperBound(bucketIndex);
                long value = snapshot.value(bucketIndex);
                TimeSeries bucketTs = bucketTimeSeries.get(bound);
                if (bucketTs == null) {
                    bucketTs = TimeSeries.newLong(timeSeries.size());
                }
                bucketTs = bucketTs.addLong(ts, value);
                bucketTimeSeries.put(bound, bucketTs);
            }
        }

        return bucketTimeSeries.double2ObjectEntrySet()
                .stream()
                .collect(Collectors.toMap(
                    e -> boundToLabel(e.getDoubleKey(), labelAllocator),
                    Map.Entry::getValue));
    }

    private static Label boundToLabel(double bound, LabelAllocator labelAllocator) {
        String binValue = (Double.compare(bound, Histograms.INF_BOUND) != 0)
            ? Doubles.toString(bound)
            : "inf";
        return labelAllocator.alloc(LabelKeys.BIN, binValue);
    }

    public static MetricType histogramBucketType(MetricType type) {
        return (type == MetricType.HIST_RATE) ? MetricType.RATE : MetricType.IGAUGE;
    }
}
