package ru.yandex.solomon.metrics.parser;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.series.TimeSeries;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public interface MetricConsumer {

    default void ensureCapacity(int countHint) {}

    void onMetricBegin(MetricType type, Labels labels, boolean memOnly);

    // TODO: onPoint(tsMillis, long/histogram) (gordiychuk@)
    void onPoint(long tsMillis, double value);
    void onPoint(long tsMillis, long value);
    void onTimeSeries(TimeSeries timeSeries);
}
