package ru.yandex.solomon.metrics.parser;

import javax.annotation.ParametersAreNonnullByDefault;

import io.netty.buffer.ByteBuf;

import ru.yandex.monlib.metrics.labels.Labels;


/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public interface TreeParser {

    void parseAndProcess(
        Labels commonLabels,
        ByteBuf bytes, MetricConsumer metricConsumer, ErrorListener errorListener,
        FormatListener formatListener, boolean onlyNewFormatWrites);

    enum InvalidMetricReason {
        EMPTY_LABELS,
        TOO_MANY_LABELS,
        INVALID_VALUE,
        INVALID_LABEL,
        INVALID_LABEL_NAME,
        INVALID_LABEL_VALUE,
        UNKNOWN_FIELD,
        UNKNOWN_FORMAT,
        INVALID_SENSOR_NAME,
        INVALID_METRIC_TYPE,
    }

    interface ErrorListener {
        default void invalidMetric(InvalidMetricReason invalidMetricReason) {}
    }

    interface FormatListener {
        default void register(boolean useNewFormat) {}
    }

    enum ErrorListenerIgnore implements ErrorListener { I }

    enum FormatListenerIgnore implements FormatListener { I }
}
