package ru.yandex.solomon.metrics.parser.json;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;

import ru.yandex.solomon.util.time.InstantUtils;


/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class JacksonUtils {

    private static final JsonFactory jsonFactory = new JsonFactory();

    /**
     * returns timestamp in milliseconds
     */
    static long readTs(JsonParser jsonParser) throws IOException {
        JsonToken next = jsonParser.nextToken();
        if (next == JsonToken.VALUE_NUMBER_INT || next == JsonToken.VALUE_NUMBER_FLOAT) {
            return TimeUnit.SECONDS.toMillis(jsonParser.getLongValue());
        } else if (next == JsonToken.VALUE_STRING) {
            return TimeUnit.SECONDS.toMillis(InstantUtils.parseToSeconds(jsonParser.getText()));
        } else {
            throw new IllegalArgumentException("cannot parse timestamp from: " + next);
        }
    }

    public static JsonParser newJsonParser(ByteBuf bytes) {
        try {
            if (bytes.hasArray()) {
                byte[] data = bytes.array();
                int offset = bytes.arrayOffset() + bytes.readerIndex();
                int len = bytes.readableBytes();
                return jsonFactory.createParser(data, offset, len);
            } else {
                InputStream in = new ByteBufInputStream(bytes);
                return jsonFactory.createParser(in);
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
