package ru.yandex.solomon.metrics.parser.json;

import java.util.function.Consumer;

import javax.annotation.ParametersAreNonnullByDefault;

import io.netty.buffer.ByteBuf;

import ru.yandex.solomon.labels.shard.ShardKey;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public interface JsonParser {

    JsonParser DEFAULT = JacksonJsonParser.I;


    void parse(ByteBuf bytes, MetricJsonConsumer consumer);

    ShardKey parseShardKeyOrThrow(ByteBuf bytes);

    MetricCommonData getCommonData(ByteBuf bytes);

    void forEachMetric(ByteBuf bytes, Consumer<MetricJson> consumer);
}
