package ru.yandex.solomon.metrics.parser.json;

import java.util.Collections;
import java.util.Map;

import javax.annotation.Nullable;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.histogram.ExplicitHistogramSnapshot;
import ru.yandex.monlib.metrics.histogram.HistogramSnapshot;
import ru.yandex.monlib.metrics.series.TimeSeries;


/**
 * @author Stepan Koltsov
 */
public class MetricJson {
    public static final double INVALID_VALUE = Double.NaN;

    public static boolean isValidValue(double value) {
        return !Double.isNaN(value);
    }

    private String name = "";
    private Map<String, String> labels = Collections.emptyMap();
    private double value = INVALID_VALUE;
    private HistogramSnapshot histogram = ExplicitHistogramSnapshot.EMPTY;
    private MetricType type = MetricType.UNKNOWN;
    @Deprecated
    private boolean deriv;
    private boolean memOnly = false;
    private long ts;
    @Nullable
    private TimeSeries timeSeries;


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getLabels() {
        return labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public double getValue() {
        return value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public HistogramSnapshot getHistogram() {
        return histogram;
    }

    public void setHistogram(HistogramSnapshot histogram) {
        this.histogram = histogram;
    }

    public long getTs() {
        return ts;
    }

    public void setTs(long ts) {
        this.ts = ts;
    }

    @Nullable
    public TimeSeries getTimeSeries() {
        return timeSeries;
    }

    public void setTimeSeries(TimeSeries timeSeries) {
        this.timeSeries = timeSeries;
    }

    @Deprecated
    public boolean isDeriv() {
        return deriv;
    }

    @Deprecated
    public void setDeriv(boolean deriv) {
        this.deriv = deriv;
    }

    public MetricType getType() {
        return type;
    }

    public void setType(MetricType type) {
        this.type = type;
    }

    public boolean getMemOnly() {
        return memOnly;
    }

    public void setMemOnly(boolean memOnly) {
        this.memOnly = memOnly;
    }
}
