package ru.yandex.solomon.metrics.parser.prometheus;

import java.util.Arrays;

import ru.yandex.monitoring.prometheus.MetricMetadata;
import ru.yandex.monlib.metrics.MetricType;

/**
 * @author Sergey Polovko
 */
final class Types {
    private Types() {}

    private static final MetricType[] TYPES;
    static {
        int max = Arrays.stream(MetricMetadata.MetricType.values())
            .filter(t -> t != MetricMetadata.MetricType.UNRECOGNIZED)
            .mapToInt(MetricMetadata.MetricType::getNumber)
            .max()
            .orElse(0);

        var types = new MetricType[max + 1];

        // unknown types will be converted to UNKNOWN
        Arrays.fill(types, MetricType.UNKNOWN);

        // known types will be converted to their analogs
        types[MetricMetadata.MetricType.GAUGE_VALUE] = MetricType.DGAUGE;
        types[MetricMetadata.MetricType.COUNTER_VALUE] = MetricType.COUNTER;
        types[MetricMetadata.MetricType.HISTOGRAM_VALUE] = MetricType.HIST_RATE;
        types[MetricMetadata.MetricType.GAUGEHISTOGRAM_VALUE] = MetricType.HIST;
        TYPES = types;
    }

    static MetricType fromProto(MetricMetadata.MetricType type) {
        return TYPES[type.getNumber()];
    }
}
