package ru.yandex.solomon.metrics.parser.spack;

import javax.annotation.ParametersAreNonnullByDefault;

import io.netty.buffer.ByteBuf;

import ru.yandex.monlib.metrics.labels.LabelAllocator;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.metrics.parser.MetricConsumer;
import ru.yandex.solomon.metrics.parser.TreeParser;


/**
 * @author Sergey Polovko
 */
@ParametersAreNonnullByDefault
public class TreeParserSpack implements TreeParser {

    private static final TreeParserSpack instance = new TreeParserSpack(Labels.allocator, "");

    private final LabelAllocator labelAllocator;
    private final String metricNameLabel;

    public TreeParserSpack(LabelAllocator labelAllocator, String metricNameLabel) {
        this.labelAllocator = labelAllocator;
        this.metricNameLabel = metricNameLabel;
    }

    public static TreeParserSpack instance() {
        return instance;
    }

    @Override
    public void parseAndProcess(
        Labels commonLabels,
        ByteBuf in,
        MetricConsumer metricConsumer,
        ErrorListener errorListener,
        FormatListener formatListener,
        boolean onlyNewFormatWrites)
    {
        SpackParserImpl parser = new SpackParserImpl(in, labelAllocator, metricNameLabel, onlyNewFormatWrites);
        parser.forEachMetric(commonLabels, metricConsumer, errorListener, formatListener);
    }
}
