package ru.yandex.solomon.metrics.parser;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.series.TimeSeries;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class MetricDataConsumer implements MetricConsumer {
    private final List<MetricData> metrics = new ArrayList<>();
    private MetricData.Builder builder;

    public List<MetricData> getMetrics() {
        return metrics;
    }

    @Override
    public void onMetricBegin(MetricType type, Labels labels, boolean memOnly) {
        builder = MetricData.newBuilder()
                .setLabels(labels)
                .setMemOnly(memOnly)
                .setType(type);
    }

    @Override
    public void onPoint(long tsMillis, double value) {
        builder.addDouble(tsMillis, value);
        metrics.add(builder.build());
    }

    @Override
    public void onPoint(long tsMillis, long value) {
        builder.addLong(tsMillis, value);
        metrics.add(builder.build());
    }

    @Override
    public void onTimeSeries(TimeSeries timeSeries) {
        builder.setTimeSeries(timeSeries);
        metrics.add(builder.build());
    }
}
