package ru.yandex.solomon.metrics.parser.json;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author Stepan Koltsov
 */
public class GenericJson {

    private List<MetricJson> metrics = new ArrayList<>();
    private Map<String, String> commonLabels = Collections.emptyMap();
    private long ts;

    public List<MetricJson> getMetrics() {
        return metrics;
    }

    public void setMetrics(List<MetricJson> metrics) {
        this.metrics = metrics;
    }

    public Map<String, String> getCommonLabels() {
        return commonLabels;
    }

    public void setCommonLabels(Map<String, String> commonLabels) {
        this.commonLabels = commonLabels;
    }

    public long getTs() {
        return ts;
    }

    public void setTs(long ts) {
        this.ts = ts;
    }

    public MetricJsonConsumer asJsonConsumer() {
        class Consumer implements MetricJsonConsumer {
            @Override
            public boolean onCommonTs(long ts) {
                GenericJson.this.ts = ts;
                return true;
            }

            @Override
            public boolean onCommonLabels(Map<String, String> labels) {
                GenericJson.this.commonLabels = labels;
                return true;
            }

            @Override
            public boolean skipMetrics() {
                return false;
            }

            @Override
            public void onMetric(MetricJson metric) {
                GenericJson.this.metrics.add(metric);
            }
        }

        return new Consumer();
    }
}
