package ru.yandex.solomon.name.resolver.client;

import java.time.Instant;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;

import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class AbstractRequest extends DefaultObject {
    public final long expiredAt;

    public AbstractRequest(Builder builder) {
        this.expiredAt = builder.expiredAt;
    }

    @NotThreadSafe
    public static abstract class Builder<T extends Builder<T>> {
        private long expiredAt;

        public Builder() {
        }

        public Builder(AbstractRequest request) {
            this.expiredAt = request.expiredAt;
        }

        public T expiredAt(long expiredAt) {
            this.expiredAt = expiredAt;
            return self();
        }

        public T expiredAt(Instant expiredAt) {
            this.expiredAt = expiredAt.toEpochMilli();
            return self();
        }

        public T self() {
            return (T) this;
        }
    }
}
