package ru.yandex.solomon.name.resolver.client;


import ru.yandex.solomon.labels.query.Selectors;

import static java.util.Objects.requireNonNull;

/**
 * @author Vladimir Gordiychuk
 */
public class FindRequest extends AbstractRequest {
    public final String cloudId;
    public final Selectors selectors;
    public final boolean filterDeleted;
    public final boolean filterReplaced;
    public final int limit;
    public final String pageToken;

    private FindRequest(Builder builder) {
        super(builder);
        this.cloudId = requireNonNull(builder.cloudId, "cloudId");
        this.selectors = requireNonNull(builder.selectors, "selectors");
        this.filterDeleted = builder.filterDeleted;
        this.filterReplaced = builder.filterReplaced;
        this.limit = builder.limit;
        this.pageToken = builder.pageToken;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder extends AbstractRequest.Builder<Builder> {
        private String cloudId;
        private Selectors selectors = Selectors.of();
        private boolean filterDeleted;
        private boolean filterReplaced;
        private int limit;
        private String pageToken = "";

        public Builder cloudId(String cloudId) {
            this.cloudId = cloudId;
            return this;
        }

        public Builder selectors(Selectors selectors) {
            this.selectors = selectors;
            return this;
        }

        public Builder filterDeleted(boolean value) {
            this.filterDeleted = value;
            return this;
        }

        public Builder filterReplaced(boolean value) {
            this.filterReplaced = value;
            return this;
        }

        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public FindRequest build() {
            return new FindRequest(this);
        }
    }
}
