package ru.yandex.solomon.name.resolver.client;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

import static java.util.concurrent.CompletableFuture.completedFuture;

/**
 * @author Vladimir Gordiychuk
 */
public class NoopNameResolverClient implements NameResolverClient {

    @Override
    public CompletableFuture<FindResponse> find(FindRequest request) {
        return completedFuture(new FindResponse(List.of(), false, ""));
    }

    @Override
    public CompletableFuture<ResolveResponse> resolve(ResolveRequest request) {
        return completedFuture(new ResolveResponse(List.of()));
    }

    @Override
    public CompletableFuture<Void> update(UpdateRequest request) {
        return completedFuture(null);
    }

    @Override
    public CompletableFuture<ShardsResponse> getShardIds() {
        return completedFuture(new ShardsResponse(Set.of()));
    }

    @Override
    public void close() {
    }
}
