package ru.yandex.solomon.name.resolver.client;

import java.util.Collection;

import static java.util.Objects.requireNonNull;

/**
 * @author Vladimir Gordiychuk
 */
public class ResolveRequest extends AbstractRequest {
    public final String cloudId;
    public final Collection<String> resourceIds;

    private ResolveRequest(Builder builder) {
        super(builder);
        this.cloudId = requireNonNull(builder.cloudId, "cloudId");
        this.resourceIds = requireNonNull(builder.resourceIds, "resourceIds");
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder extends AbstractRequest.Builder<Builder> {
        private String cloudId;
        private Collection<String> resourceIds;

        public Builder cloudId(String cloudId) {
            this.cloudId = cloudId;
            return this;
        }

        public Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = resourceIds;
            return this;
        }

        public ResolveRequest build() {
            return new ResolveRequest(this);
        }
    }
}
