package ru.yandex.solomon.name.resolver.client;

import ru.yandex.solomon.labels.query.Selector;
import ru.yandex.solomon.labels.query.Selectors;

/**
 * @author Vladimir Gordiychuk
 */
public class ResourceLabels {
    public static final String FOLDER_ID = "folderId";
    public static final String SERVICE = "service";
    public static final String TYPE = "type";
    public static final String RESOURCE = "resource";
    public static final String NAME = "name";
    public static final String ID = "id";
    public static final String SEVERITY = "severity";

    public static boolean match(Resource resource, Selectors selectors) {
        for (var selector : selectors) {
            if (!match(resource, selector)) {
                return false;
            }
        }
        return true;
    }

    public static boolean match(Resource resource, Selector selector) {
        switch (selector.getKey()) {
            case FOLDER_ID:
                return selector.match(resource.folderId);
            case SERVICE:
                return selector.match(resource.service);
            case TYPE:
                return selector.match(resource.type);
            case RESOURCE:
                if (selector.isExact()) {
                    return selector.match(resource.getNameOrId()) || selector.match(resource.resourceId);
                }
                return selector.match(resource.getNameOrId());
            case ID:
                return selector.match(resource.resourceId);
            case NAME:
                return selector.match(resource.name);
            case SEVERITY:
                return selector.match(resource.severity.name());
            default:
                return selector.match(null);
        }
    }
}
