package ru.yandex.solomon.name.resolver.client;

import java.time.Instant;
import java.util.Map;

/**
 * @author Vladimir Gordiychuk
 */
public class ResourcesTestSupport {
    private static final long UPDATED_AT = Instant.parse("2020-10-27T06:56:46Z").toEpochMilli();

    public static Resource staticResource() {
        return new Resource()
                .setCloudId("cloudId")
                .setFolderId("folderId")
                .setService("service")
                .setResourceId("resourceId")
                .setType("type")
                .setName("name")
                .setResourceComplexId(Map.of("k1", "v1", "k2", "v2"))
                .setSeverity(Resource.Severity.CRITICAL)
                .setResponsible("responsible")
                .setEnvironment("env")
                .setUpdatedAt(UPDATED_AT)
                .setDeletedAt(0);
    }
}
