package ru.yandex.solomon.name.resolver.client.grpc;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.Flow.Subscription;


/**
 * @author Vladimir Gordiychuk
 */
public class ServerStatusObserver implements Flow.Subscriber<ru.yandex.solomon.name.resolver.protobuf.ServerStatusResponse> {
    private final CompletableFuture<ServerStatusResponse> doneFuture;
    private final ServerStatusResponse response = new ServerStatusResponse(0, "");

    public ServerStatusObserver(CompletableFuture<ServerStatusResponse> doneFuture) {
        this.doneFuture = doneFuture;
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        subscription.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(ru.yandex.solomon.name.resolver.protobuf.ServerStatusResponse proto) {
        response.combine(Proto.fromProto(proto));
    }

    @Override
    public void onError(Throwable throwable) {
        doneFuture.completeExceptionally(throwable);
    }

    @Override
    public void onComplete() {
        doneFuture.complete(response);
    }
}
