package ru.yandex.solomon.name.resolver.client.grpc;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;

import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Vladimir Gordiychuk
 */
public class ServerStatusResponse extends DefaultObject {
    public final Multimap<String, String> shardsByNode = HashMultimap.create();
    public long stateHash;
    public String leader;

    public ServerStatusResponse(long stateHash, String leader) {
        this.stateHash = stateHash;
        this.leader = leader;
    }

    public ServerStatusResponse addShard(String host, String shardId) {
        shardsByNode.put(host, shardId);
        return this;
    }

    public ServerStatusResponse combine(ServerStatusResponse snapshot) {
        leader = snapshot.leader;
        stateHash = snapshot.stateHash;
        shardsByNode.putAll(snapshot.shardsByNode);
        return this;
    }
}
