package ru.yandex.solomon.name.resolver.client;

import org.junit.Test;

import ru.yandex.solomon.labels.query.Selectors;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static ru.yandex.solomon.name.resolver.client.ResourcesTestSupport.staticResource;

/**
 * @author Vladimir Gordiychuk
 */
public class ResourceLabelsTest {

    @Test
    public void emptySelector() {
        var resource = staticResource();
        assertTrue(ResourceLabels.match(resource, Selectors.of()));
    }

    @Test
    public void matchByFolder() {
        assertTrue(ResourceLabels.match(staticResource().setFolderId("alice"), Selectors.parse("folderId=alice")));
        assertTrue(ResourceLabels.match(staticResource().setFolderId("bob"), Selectors.parse("folderId=b?b")));
        assertFalse(ResourceLabels.match(staticResource().setFolderId("alice"), Selectors.parse("folderId=bob")));
    }

    @Test
    public void matchByService() {
        assertTrue(ResourceLabels.match(staticResource().setService("one"), Selectors.parse("service=one")));
        assertTrue(ResourceLabels.match(staticResource().setService("two"), Selectors.parse("service=t*o")));
        assertFalse(ResourceLabels.match(staticResource().setService("one"), Selectors.parse("service=two")));
    }

    @Test
    public void matchByType() {
        assertTrue(ResourceLabels.match(staticResource().setType("disk"), Selectors.parse("type=disk")));
        assertTrue(ResourceLabels.match(staticResource().setType("vm"), Selectors.parse("type=vm")));
        assertFalse(ResourceLabels.match(staticResource().setType("disk"), Selectors.parse("type=vm")));
    }

    @Test
    public void matchByResourceId() {
        assertTrue(ResourceLabels.match(staticResource().setResourceId("alice"), Selectors.parse("resource=alice")));
        assertTrue(ResourceLabels.match(staticResource().setResourceId("bob"), Selectors.parse("resource=bob")));
        assertFalse(ResourceLabels.match(staticResource().setResourceId("alice"), Selectors.parse("resource=b*")));
    }

    @Test
    public void matchByResourceName() {
        assertTrue(ResourceLabels.match(staticResource().setName("alice"), Selectors.parse("resource=alice")));
        assertTrue(ResourceLabels.match(staticResource().setName("bob"), Selectors.parse("resource=bob")));
        assertFalse(ResourceLabels.match(staticResource().setName("alice"), Selectors.parse("resource=b*")));
    }

    @Test
    public void matchBySeverity() {
        assertTrue(ResourceLabels.match(staticResource().setSeverity(Resource.Severity.NON_CRITICAL), Selectors.parse("severity=NON_CRITICAL")));
        assertTrue(ResourceLabels.match(staticResource(), Selectors.parse("severity=CRITICAL")));
        assertTrue(ResourceLabels.match(staticResource().setSeverity(Resource.Severity.HIGHLY_CRITICAL), Selectors.parse("severity=*CRITICAL*")));
        assertFalse(ResourceLabels.match(staticResource(), Selectors.parse("severity=NORMAL")));
    }
}
