package ru.yandex.solomon.name.resolver.client;

import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotEquals;
import static ru.yandex.solomon.name.resolver.client.ResourcesTestSupport.staticResource;

/**
 * @author Vladimir Gordiychuk
 */
public class ResourceTest {

    @Test
    public void equal() {
        Resource resource = staticResource();
        assertEquals(resource, resource);
        assertEquals(resource, staticResource());
    }

    @Test
    public void copy() {
        assertEquals(new Resource(staticResource()), staticResource());
    }

    @Test
    public void copyReindexAt() {
        var original = staticResource().setReindexAt(6123);
        var copy = new Resource(original);
        assertEquals(original, copy);
        assertEquals(original.reindexAt, copy.reindexAt);
    }

    @Test
    public void differentId() {
        var left = staticResource().setResourceId("left");
        var right = staticResource().setResourceId("right");
        assertNotEquals(left, right);
        assertNotEquals(right, left);
    }
}
