package ru.yandex.solomon.operation;

import java.util.UUID;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.protobuf.util.Timestamps;

import ru.yandex.monitoring.api.v3.Operation;
import ru.yandex.solomon.exception.handlers.GrpcApiExceptionResolver;
import ru.yandex.solomon.util.Proto;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class OperationDtoConverter {

    public Operation wrap(Message message) {
        return Operation.newBuilder()
                .setId(UUID.randomUUID().toString())
                .setDescription("Operation synchronous")
                .setCreatedAt(Timestamps.fromNanos(System.nanoTime()))
                .setModifiedAt(Timestamps.fromNanos(System.nanoTime()))
                .setDone(true)
                .setResponse(Proto.pack(message))
                .build();
    }

    public Operation wrap(Message message, @Nullable Throwable throwable) {
        if (throwable != null) {
            return wrap(throwable);
        }
        return wrap(message);
    }

    public Operation wrap(Throwable throwable) {
        var exception = GrpcApiExceptionResolver.doResolveException(throwable);
        var builder = com.google.rpc.Status.newBuilder().setCode(exception.getStatus().getCode().value())
                .setMessage(exception.getMessage());
        var statusProto = builder.build();
        return Operation.newBuilder()
                .setId(UUID.randomUUID().toString())
                .setDescription("Operation synchronous")
                .setCreatedAt(Timestamps.fromNanos(System.nanoTime()))
                .setModifiedAt(Timestamps.fromNanos(System.nanoTime()))
                .setDone(true)
                .setError(statusProto)
                .build();
    }

    public Operation wrap(Void unused, @Nullable Throwable throwable) {
        return wrap(Any.getDefaultInstance(), throwable);
    }

    public Operation wrap(String operationId, @Nullable Throwable throwable) {
        return wrap(Any.getDefaultInstance(), throwable).toBuilder()
                .setId(operationId)
                .build();
    }
}
