package ru.yandex.solomon.quotas.manager;

import java.time.Instant;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.db.model.Quota;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class QuotaLimit {
    private final String indicator;
    private final long limit;

    private final String updatedBy;
    private final Instant updatedAt;

    public QuotaLimit(String indicator, long limit, String updatedBy, Instant updatedAt) {
        this.indicator = indicator;
        this.limit = limit;
        this.updatedBy = updatedBy;
        this.updatedAt = updatedAt;
    }

    public static QuotaLimit fromModel(Quota model) {
        return new QuotaLimit(model.getIndicator(), model.getLimit(), model.getUpdatedBy(), model.getUpdatedAt());
    }

    public String getIndicator() {
        return indicator;
    }

    public long getLimit() {
        return limit;
    }

    public String getUpdatedBy() {
        return updatedBy;
    }

    public Instant getUpdatedAt() {
        return updatedAt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotaLimit that = (QuotaLimit) o;
        return limit == that.limit &&
            indicator.equals(that.indicator) &&
            updatedBy.equals(that.updatedBy) &&
            updatedAt.equals(that.updatedAt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(indicator, limit, updatedBy, updatedAt);
    }

    @Override
    public String toString() {
        return "QuotaLimit{" +
            "indicator='" + indicator + '\'' +
            ", limit=" + limit +
            ", updatedBy='" + updatedBy + '\'' +
            ", updatedAt=" + updatedAt +
            '}';
    }
}
