package ru.yandex.solomon.quotas.manager;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class QuotaValue {
    private final String indicator;
    private final long value;

    public QuotaValue(String indicator, long value) {
        this.indicator = indicator;
        this.value = value;
    }

    public String getIndicator() {
        return indicator;
    }

    public long getValue() {
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotaValue that = (QuotaValue) o;
        return value == that.value &&
            indicator.equals(that.indicator);
    }

    @Override
    public int hashCode() {
        return Objects.hash(indicator, value);
    }

    @Override
    public String toString() {
        return "QuotaValue{" +
            "indicator='" + indicator + '\'' +
            ", value=" + value +
            '}';
    }
}
