package ru.yandex.solomon.quotas.manager;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class QuotaValueWithLimit {
    private final String indicator;
    private final long value;
    private final long limit;

    public QuotaValueWithLimit(String indicator, long value, long limit) {
        this.indicator = indicator;
        this.value = value;
        this.limit = limit;
    }

    public String getIndicator() {
        return indicator;
    }

    public long getValue() {
        return value;
    }

    public long getLimit() {
        return limit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotaValueWithLimit that = (QuotaValueWithLimit) o;
        return value == that.value &&
            limit == that.limit &&
            indicator.equals(that.indicator);
    }

    @Override
    public int hashCode() {
        return Objects.hash(indicator, value, limit);
    }

    @Override
    public String toString() {
        return "QuotaValueWithLimit{" +
            "indicator='" + indicator + '\'' +
            ", value=" + value +
            ", limit=" + limit +
            '}';
    }
}
