package ru.yandex.solomon.quotas.manager;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class Scope {
    /**
     * E.g. coremon, fetcher, alerting
     */
    private final String namespace;
    /**
     * E.g. project, cluster, service, shard, url
     */
    private final String type;
    /**
     * E.g. {{projectId}}, {{shardId}}, {{url}}, null
     * null is reserved for `defaults`
     */
    @Nullable
    private final String identifier;

    private Scope(String namespace, String type, @Nullable String identifier) {
        this.namespace = namespace;
        this.type = type;
        this.identifier = identifier;
    }

    public static Scope of(String namespace, String scopeType, String scopeId) {
        return new Scope(namespace, scopeType, scopeId);
    }

    public static Scope defaultOf(String namespace, String scopeType) {
        return new Scope(namespace, scopeType, null);
    }

    public boolean isDefaults() {
        return identifier == null;
    }

    public String getNamespace() {
        return namespace;
    }

    public String getType() {
        return type;
    }

    @Nullable
    public String getIdentifier() {
        return identifier;
    }
}
