package ru.yandex.solomon.quotas.manager.fetcher;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;

import ru.yandex.solomon.alert.protobuf.ERequestStatusCode;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class GrpcApiException {
    public static StatusRuntimeException of(ERequestStatusCode requestStatus, String message) {
        Status status = toGrpcStatus(requestStatus).withDescription(requestStatus.name() + ": " + message);
        return new StatusRuntimeException(status);
    }

    private static Status toGrpcStatus(ERequestStatusCode status) {
        switch (status) {
            case OK:
                return Status.OK;
            case INTERNAL_ERROR:
                return Status.INTERNAL;
            case SHARD_NOT_INITIALIZED:
            case NODE_UNAVAILABLE:
                return Status.UNAVAILABLE;
            case DEADLINE_EXCEEDED:
                return Status.DEADLINE_EXCEEDED;
            case INVALID_REQUEST:
                return Status.INVALID_ARGUMENT;
            case NOT_FOUND:
                return Status.NOT_FOUND;
            case CONCURRENT_MODIFICATION:
                return Status.ALREADY_EXISTS;
            case RESOURCE_EXHAUSTED:
                return Status.RESOURCE_EXHAUSTED;
            case UNKNOWN:
            case UNRECOGNIZED:
            default:
                return Status.UNKNOWN;
        }
    }
}
