package ru.yandex.solomon.quotas.watcher.pumpkin;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.quotas.watcher.QuotaWatcher;

/**
 * These hardcoded quotas are last resort when both Ydb and disk cache are not working (e.g. filesystem gone)
 *
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class PumpkinQuotas {

    private static Map<String, Map<QuotaWatcher.Key, Long>> QUOTAS = Map.of(
        "alerting", Map.of(
            QuotaWatcher.Key.ofDefaults("project", "alerts.count"), 1000L
        )
    );

    public static Map<QuotaWatcher.Key, Long> get(String namespace) {
        return QUOTAS.getOrDefault(namespace, Map.of());
    }

}
